/*Copyright (c) 2012, Sierra Wireless, Inc
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this
 list of conditions and the following disclaimer in the documentation and/or
 other materials provided with the distribution.
Neither the name of Sierra Wireless Inc, Richmond, Canada nor the names of its
 contributors may be used to endorse or promote products derived from this
 software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABIL ITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*****************************************************************************/
/*  Header files                                                             */
/*****************************************************************************/

#include "adl_global.h"
#include "generated.h"
#include "wip.h"

/*****************************************************************************/
/*  Defines                                                                  */
/*****************************************************************************/

#define NORMAL_TRACE_LEVEL      4
#define ERROR_TRACE_LEVEL       1

/*****************************************************************************/
/*  Prototypes                                                               */
/*****************************************************************************/

extern void CfgGprs ( void ( *EntryPoint ) ( void ) ) ;
extern void main_task ( void );

extern void AppliEntryPoint ( void );

/***************************************************************************/
/*  Function   : MainTask                                                  */
/*-------------------------------------------------------------------------*/
/*  Object     : Customer application initialisation                       */
/*                                                                         */
/*  Return     : None                                                      */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  InitType          | x |   |   |  Application start mode reason         */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/

void main_task ( void )
{
    s8 ret;

    TRACE ( ( NORMAL_TRACE_LEVEL, "Embedded Application : Main" ) );

    /* Initialize the stack */
    ret = wip_netInitOpts ( WIP_NET_OPT_END );

    if ( OK == ret )
    {
        /* Initialize GPRS connection      */
    CfgGprs ( AppliEntryPoint ) ;
    }
    else
    /* Don't initialize any bearer; only        */
    /* localhost=127.0.0.1 will be reachable.   */
        AppliEntryPoint ( );
}
